<?php 

/**
 Printserver Installer
 
 @Copyright 2015 Stefan Rick
 @author Stefan Rick
 Mail: stefan@rick-software.de
 Web: http://www.netzberater.de
 
 */

class Printserver_Setup extends Service {
	public $scriptPath = '';
	
	public function __construct(){		
		parent::__construct();		
		$this->registerLocale(dirname(__FILE__).'/../locale', 'printserver');
		$this->pluginname = _('Printserver Setup');				
		$this->scriptPath = dirname(__FILE__).'/../scripts/';
		
		if($this->checkLicense(true) == false)
			return true;								
		
		if($_GET['ajax'] == 1 && $_GET['action'] == 'install'){
			//Function to get Progress of Installation
			$this->_install(1);
			ob_end_clean();
			echo implode('<br />', $this->view->message);
			ob_flush();
			die();
		}
		
		$this->_checkinstall();
		
		if(isset($_GET['action'])){			
			if($_GET['action'] == 'install'){							
				$this->_install();
			}
			if($_GET['action'] == 'uninstall'){
				$this->_uninstall();
			}			
			$this->_checkinstall();
		}
		$this->showHelpSidebar();
					
	}			
	
	private function _checkinstall(){
		
		$this->view->installed = shell_exec('dpkg -s cups | grep "installed"');
		
		return true;
	}
	
	private function _install($ajax = 0){
		if($this->view->installed){
			//return false;
		}

		if($ajax == 0){
			if($this->getProgressWithAjax('/opt/max2play/cache/install_printserver.txt', 1, 1)){
				$shellanswer = $this->writeDynamicScript(array($this->scriptPath."install_printserver.sh >> /opt/max2play/cache/install_printserver.txt 2>&1 &"));
			}
		}else{
			$status = $this->getProgressWithAjax('/opt/max2play/cache/install_printserver.txt');
			$this->view->message[] = nl2br($status);
			if(strpos($status, 'finished') !== FALSE){
				//Finished Progress - did not delete progressfile yet
				$this->view->message[] = _t('Printserver is now installed!');
				shell_exec('rm /opt/max2play/cache/install_printserver.txt');
			}
		}
		return true;
		
	}
	public function showHelpSidebar(){
		global $helpSidebar;
		$helpSidebar['wikilink'] = 'https://www.max2play.com/en/wiki/using-the-plugin-printserver/';
		return true;
	}
		
}

$ps = new Printserver_Setup();

include_once(dirname(__FILE__).'/../view/setup.php');

