<?php
/**
	 Printserver Setup
	
	 @Copyright 2014 Stefan Rick
	 @author Stefan Rick
	 Mail: stefan@rick-software.de
 	 Web: http://www.netzberater.de

 */ 
?>											

<h1 class="entry-header">
	<?php echo _t("Printserver Setup") ?>
</h1>
<div class="entry-content">
	<?php if(isset($ps->view->message[0])){ ?>
		<div class="ui-widget">
			<div class="ui-state-highlight ui-corner-all" style="margin-bottom: 10px; padding: 0.4em .7em;">
				<p>
					<span class="ui-icon ui-icon-info" style="float: left; margin-right: .3em;"></span>
					<?php echo implode('<br /><span class="ui-icon ui-icon-info" style="float: left; margin-right: .3em;"></span>', $ps->view->message); ?>					
				</p>
			</div>
		</div>
	<?php } ?>		
	<?php echo _t("This addon installs all required packages to use this device as a printserver. Just connect your USB-Printer and configure it with a webinterface.") ?>
	<?php echo _t("More information on how to setup your printserver: <a href='http://www.spiegel.de/netzwelt/gadgets/projekt-fuer-den-raspberry-pi-so-basteln-sie-sich-einen-w-lan-drucker-a-921851.html' target='blank'>German instructions</a>"); ?>
	<br /><br />
	
	<form action="" method="get">
	<input type="hidden" id="action" name="action" value="" />
	
<?php if($ps->view->installed) { ?>			
	
	<p class="ui-state-default ui-corner-all" style="padding:4px;margin-bottom:1em;">
			<span class="ui-icon ui-icon-wrench" style="float:left; margin:-2px 5px 0 0;"></span>
					<?php echo _t("Printserver is installed!") ?>			
			</p>	
	<b><a class="button-small" href="http://<?php echo $_SERVER['HTTP_HOST'].':631'; ?>" target="blank"><?php echo _t("Open Printserver webinterface") ?></a></b>
	<br /><br />
	
	<?php echo _t("When installing / setup new printers use this for login in the administration interface: user 'root' and password 'max2play'<br />You also need to accept the invalid SSL-Certificate to access the administration interface with your browser"); ?><br /><br /> 
	<?php echo _t("Important: on new Max2Play-Images based on Debian Stretch, you need to use user 'pi' and password 'max2play' for login to add new printers.")?>
	<br /><br />	
	<b><?php echo _t("Re-Install Printserver") ?></b><br />
	<?php echo _t("Get the latest Updates for CUPS or just Re-Install if something is broken."); ?><br />
	<br />
	<input type="button" value="<?php echo _('install') ?>" name="install" onclick="document.getElementById('action').value='install';submit();" />
<?php }else { ?>	
	<p class="ui-state-default ui-corner-all" style="padding:4px;margin-bottom:1em;">
			<span class="ui-icon ui-icon-wrench" style="float:left; margin:-2px 5px 0 0;"></span>
					<?php echo _t("Printserver is NOT installed yet!") ?>			
			</p>
	<b><?php echo _t("Install Printserver") ?></b>
	<br />
	<input type="button" value="<?php echo _('install') ?>" name="install" onclick="document.getElementById('action').value='install';submit();" />
	
<?php } ?>
	
	</form>

	<br /><br />
	<a href="#javascript" onclick="document.getElementById('debug').style.display='';return false;">DEBUG Informationen</a>
	<textarea id="debug" rows="30" cols="70" style="display:none;"><?php foreach ($ps->view->debug as $key => $debug) {
			echo "#### ". $key. " ####\n"; 
			 echo $debug." \n\n"; 
		 }?>
	</textarea>

</div>	