<?php 

/**
 Setup for Raspberry PI 2.8" LCD Touchdisplay
 
 @Copyright 2015 Stefan Rick
 @author Stefan Rick
 Mail: stefan@rick-software.de
 Web: http://www.netzberater.de
 
 */

class Rpitouchdisplay_Setup extends Service {	
	public $viewname = 'RPi Display';
	public $scriptPath = '';	
	public $supportedDisplays = array('28watterott' => '2.8" Watterott Touchdisplay', '24hat' => '2.4" 4DPI-24-Hat', '7inch' => '7" Touchdisplay', 'Adafruit28inch' => 'Adafruit 2.8" Touchdisplay', 'Adafruit35inch' => 'Adafruit 3.5" Touchdisplay');
	
	public function __construct(){		
		parent::__construct();		
		$this->registerLocale(dirname(__FILE__).'/../locale', 'rpitouchdisplay');
		$this->pluginname = _('RPi Display');				
		$this->scriptPath = dirname(__FILE__).'/../scripts/';
		
		// Only for Raspberry PI!
		if($this->getSystemUser() != 'pi'){
			$this->view->message[] = _("Only for Raspberry PI!");
			return true;
		}
		
		if($this->checkLicense(true) == false)
			return true;
		
		if($_REQUEST['ajax'] == 1 && $_REQUEST['action'] == 'install'){
			//Function to get Progress of Installation
			$this->_install(1);
			ob_end_clean();
			echo implode('<br />', $this->view->message);
			ob_flush();
			die();
		}
			
		if(isset($_REQUEST['action'])){
			if($_REQUEST['action'] == 'start'){							
				//Check for existing XSesssion
				$checkX = $this->writeDynamicScript(array('ps -Al | grep xinit | wc -l'));
				if(trim($checkX) == 0){
					$this->writeDynamicScript(array('export DISPLAY=\':0\';su -l pi -c startx > /dev/null 2>&1 &'));
					sleep(3);
				}
			}
			
			if($_REQUEST['action'] == 'stop'){			
				$this->writeDynamicScript(array('killall lxsession'));				
			}
			if($_REQUEST['action'] == 'removeDisplaySettings'){
				$this->removeDisplaySettings();
			}
			
			if($_REQUEST['action'] == 'save'){
				$this->_save();			
			}
			if($_REQUEST['action'] == 'install'){							
				$this->_install();
				sleep(1);
			}
		
		}
		$this->_getSettings();
		$this->getAddonVersion();
		//$this->view->autostart = $this->checkAutostart($this->pname, true);
		$this->showHelpSidebar();		
	}	
	
	private function _getSettings(){
		$this->view->koditouchmouse = file_exists('/home/'.$this->getSystemUser().'/.kodi/userdata/keymaps/touchmax2play.xml') ? 1 : 0;
		$this->view->rotatedisplay = $this->getConfigFileParameter('/boot/config.txt', 'lcd_rotate');
		$this->view->removecursor = trim(shell_exec('grep -i "nocursor" /etc/X11/xinit/xserverrc | wc -l'));
		$this->view->consoleenabled = trim(shell_exec('grep -i "fbcon=map:10 fbcon=font:VGA8x8" /boot/cmdline.txt | wc -l'));
		$this->view->displaytype = $this->getConfigFileParameter('/opt/max2play/options.conf', 'display');
		$this->view->display_default_lcd = $this->getConfigFileParameter('/boot/config.txt', 'display_default_lcd');
		$this->view->brightness = trim(shell_exec('cat /sys/class/backlight/rpi_backlight/brightness'));
		return true;	
	}
	
	private function _save(){
		$this->_getSettings();
		if($this->view->displaytype != '7inch'){
			// Not for the 7inch display (breaks input!)
			if(isset($_REQUEST['consoleenabled']) && $this->view->consoleenabled != 1){
				$this->writeDynamicScript(array("sed -i 's/rootwait/rootwait fbcon=map:10 fbcon=font:VGA8x8/' /boot/cmdline.txt; /bin/con2fbmap 1 1;"));			
				$this->view->message[] = _t('Console Output enabled for RPi-Display');
			}elseif(!isset($_REQUEST['consoleenabled']) && $this->view->consoleenabled == 1){
				$this->writeDynamicScript(array("sed -i 's/ fbcon=map:10 fbcon=font:VGA8x8//' /boot/cmdline.txt; /bin/con2fbmap 1 0;"));
				$this->view->message[] = _t('Console Output disabled for RPi-Display - Please Reboot');
			}			
		}
		if(isset($_REQUEST['display_default_lcd']) && $this->view->display_default_lcd === "0"){
			$this->saveConfigFileParameter('/boot/config.txt', 'display_default_lcd', "1");
			$this->view->message[] = _t('LCD Display now Default - Please Reboot');
		}elseif(!isset($_REQUEST['display_default_lcd']) && $this->view->display_default_lcd !== "0"){
			$this->saveConfigFileParameter('/boot/config.txt', 'display_default_lcd', "0");
			$this->view->message[] = _t('HDMI Display now Default - Please Reboot');
		}
		if(isset($_REQUEST['rotatedisplay']) && $this->view->rotatedisplay < 1){
			$this->saveConfigFileParameter('/boot/config.txt', 'lcd_rotate', 2);
			$this->view->message[] = _t('Screen Rotation set for RPi-Display - Please Reboot');
		}elseif(!isset($_REQUEST['rotatedisplay']) && $this->view->rotatedisplay > 0){
			$this->saveConfigFileParameter('/boot/config.txt', 'lcd_rotate', 0);
			$this->view->message[] = _t('Screen Rotation set for RPi-Display - Please Reboot');
		}
		if(isset($_REQUEST['removecursor']) && $this->view->removecursor != 1){
			$this->writeDynamicScript(array("sed -i 's/\(exec .*\)$/& -nocursor/' /etc/X11/xinit/xserverrc"));
			$this->view->message[] = _t('Cursor removed for RPi-Display - Please Reboot');
		}elseif(!isset($_REQUEST['removecursor']) && $this->view->removecursor == 1){
			$this->writeDynamicScript(array("sed -i 's/ -nocursor//' /etc/X11/xinit/xserverrc"));
			$this->view->message[] = _t('Cursor activated for RPi-Display - Please Reboot');
		}
		if(isset($_REQUEST['koditouchmouse']) && $this->view->koditouchmouse != 1){
			$this->writeDynamicScript(array('echo -e "<keymap>\n<global>\n<mouse>\n<mousedrag>LeftClick</mousedrag>\n</mouse>\n</global>\n</keymap>" > /home/'.$this->getSystemUser().'/.kodi/userdata/keymaps/touchmax2play.xml'));
			$this->view->message[] = _t('Kodi Mouse Settings changed to 1-Click - Please Reboot');
		}elseif(!isset($_REQUEST['koditouchmouse']) && $this->view->koditouchmouse == 1){
			$this->writeDynamicScript(array('rm /home/'.$this->getSystemUser().'/.kodi/userdata/keymaps/touchmax2play.xml'));
			$this->view->message[] = _t('Kodi Mouse Settings set to default - Please Reboot');
		}
		if(isset($_REQUEST['brightness']) && $this->view->brightness != $_REQUEST['brightness']){
		    $this->writeDynamicScript(array('echo '.intval($_REQUEST['brightness']).' > /sys/class/backlight/rpi_backlight/brightness'));
		}
		
		return true;
	}
	
	/**
	 * try to get Version / at least show if it is installed
	 * @return boolean
	 */
	private function getAddonVersion(){						
		if(strpos($this->getConfigFileParameter('/boot/config.txt', 'dtoverlay'), 'rpi-display') !== FALSE || strpos($this->getConfigFileParameter('/opt/max2play/options.conf', 'display'), '7inch') !== FALSE){
			$this->view->installed = true;
		}else{
			$this->view->installed = false;
		}
		return true;
	}
	
	private function _install($ajax = 0){
		$display = $_REQUEST['display'];
		if(!in_array($display, array_keys($this->supportedDisplays))){
			$this->view->message[] = _t('Display not supported');
			return false;
		}
		if($ajax == 0){
			if($this->getProgressWithAjax('/opt/max2play/cache/install_rpidisplay.txt', 1, 0, 30)){				
				$shellanswer = $this->writeDynamicScript(array($this->scriptPath."install-rpi-display.sh $display >> /opt/max2play/cache/install_rpidisplay.txt 2>&1 &"), false, true);
			}
		}else{
			$status = $this->getProgressWithAjax('/opt/max2play/cache/install_rpidisplay.txt', 0,0, 30);
			$this->view->message[] = nl2br($status);
			if(strpos($status, 'finished') !== FALSE){
				//Finished Progress - did not delete progressfile yet
				$this->saveConfigFileParameter('/opt/max2play/options.conf', 'display', $display);
				$this->view->message[] = _('INSTALL SUCCESSFUL');
				shell_exec('rm /opt/max2play/cache/install_rpidisplay.txt');				
			}
		}			
	 	return true;
	}		
	
	public function removeDisplaySettings(){
		$shellanswer = $this->writeDynamicScript(array("rm /usr/share/X11/xorg.conf.d/99-fbturbo.conf 2>&1;rm /etc/X11/xorg.conf.d/99-ads7846-cal.conf 2>&1"));
		$this->view->message[] = _t('Display related settings removed');
		$this->view->message[] = $shellanswer;
		return true;
	}
	
	public function showHelpSidebar(){
		global $helpSidebar;
		$helpSidebar['title'] = _t('Help - RPi-Display');
		$helpSidebar['content'] = _t('<ul><li>Installer for Touchdisplays on Raspberry PI. Just install and use it with Jivelite and other desktop applications!</li><li>This display is recommended: <a href="http://shop.max2play.com/en/raspi-display.html" target="_blank">Display for Raspberry PI</a></li></ul>');
		return true;
	}
		
}

$rpid = new Rpitouchdisplay_Setup();

include_once(dirname(__FILE__).'/../view/setup.php');

