#!/bin/bash

# http://odroid.com/dokuwiki/doku.php?id=en:c1_lcdshield

# Problem: Undecorate geht nicht in Lubuntu
# LXDE statt Lubuntu einstellen: /etc/lightdm/lightdm.conf.d/
echo -e "[SeatDefaults]\nuser-session=lxde\n" > /etc/lightdm/lightdm.conf.d/20-lxde.conf
rm /etc/lightdm/lightdm.conf.d/20-lubuntu.conf

# Set Apps to Fullscreen
sed -i 's@</applications>@<application class="\*">\n<decor>no</decor><fullscreen>yes</fullscreen></application>\n</applications>@' /home/odroid/.config/openbox/lxde-rc.xml


##### HISTORY
# Update to latest Version
odroid-utility.sh 
reboot

# Make manual Changes for hifi-shield, etc.
nano /media/boot/boot.ini

# Startx for running XServer on Display
sed -i "s@^exit 0@su -l odroid -c \"startx &\"\n\nexit 0@" /etc/rc.local
# Modules needed for Display
echo -e "spicc\nfbtft_device name=odroidc_tft32 rotate=270 gpios=reset:116,dc:115 speed=32000000 cs=0" >> /etc/modules
# To run Xwindow on Touchdisplay
echo -e "Section \"Device\"\n    Identifier    \"C1 fbdev\"\n    Driver        \"fbdev\"\n    Option        \"fbdev\" \"/dev/fb2\"\nEndSection" > /usr/share/X11/xorg.conf.d/99-odroidc-tftlcd.conf
# Override XWindow Start
echo "manual" > /etc/init/lightdm.override
echo 'SUBSYSTEM=="input", ATTRS{name}=="ADS7846 Touchscreen", ENV{DEVNAME}=="*event*", SYMLINK+="input/touchscreen"' > /etc/udev/rules.d/95-ads7846.rules
sudo apt-get install evtest tslib libts-bin xinput-calibrator -y
reboot
# Calibration
DISPLAY=:1 xinput_calibrator
mkdir -p /etc/X11/xorg.conf.d/
echo -e "Section \"InputClass\"\n   Identifier \"calibration\"\n   MatchProduct \"ADS7846 Touchscreen\"\n   Option \"Calibration\" \"160 3777 3862 88\"\n   Option \"SwapAxes\" \"0\"\nEndSection" > /etc/X11/xorg.conf.d/99-calibration.conf

# eth1 udev rules! => eth0!


