#!/bin/bash

# https://github.com/watterott/RPi-Display/blob/master/docu/FBTFT-Install.md
# http://www.circuitbasics.com/setup-lcd-touchscreen-raspberry-pi/

VERSION=$(lsb_release -a 2>/dev/null | grep "Codename" | sed "s/Distributor ID:\t//;s/Codename:\t//")

# Short with script:
# wget -N https://github.com/watterott/RPi-Display/raw/master/rpi-display.sh -O /opt/max2play/cache/
# chmod 777 /opt/max2play/cache/rpi-display.sh
# /opt/max2play/cache/rpi-display.sh 270

######## Long Version #########

## TODO: block /dev/input/event0 from being grabbed from jivelite -> Jivelite to control 
# -> kodi http://forum.kodi.tv/showthread.php?tid=221804
## OR: calibrate display for Kodi (bigger displays): 
# -> http://forum.kodi.tv/showthread.php?tid=222880 and http://markamc.traki-iski.co.uk/raspberry-pixbian-egalax-touchscreen/ 
# https://github.com/vpeter4/tslib for Kodi calibration tslib
# Turn on fbcp for display mirroring from HDMI / turn off if not needed 

NEWKERNEL=$(uname -a | grep "\(4\|5\)\." | wc -l)
if [ "$NEWKERNEL" -lt "1" ]; then 
	apt-get update
	echo "Kernel Update"	
	KERNELUPDATE=$(REPO_URI=https://github.com/notro/rpi-firmware rpi-update)	
	if [ "$KERNELUPDATE" -gt "0" ]; then 
		echo "finished - something went wrong! Please try to install again!"
	else	
		echo "finished Kernel update - <b><a href='/plugins/max2play_settings/controller/Basic.php?action=reboot'>Please Reboot and start installation again!</a></b>"
	fi	
	exit 0
fi

# for 7" Display - not much to do...
if [ "$1" == "7inch" ]; then
	apt-get install tslib libts-bin xinput --yes --force-yes
	# for Debian Jessie Screensaver - TODO: TEST
	apt-get remove xscreensaver --yes
	echo "finished <b><a href='/plugins/max2play_settings/controller/Basic.php?action=reboot'>Please Reboot!</a></b>"
	exit 0
fi

# for 2.5" Display 4DPI-24-Hat
if [ "$1" == "24hat" ]; then
	wget http://www.4dsystems.com.au/downloads/4DPi/4DPi-24-HAT/4DPi-24-HAT_kernel_R_1_0.tar.gz	     
	tar -xzvf 4DPi-24-HAT_kernel_R_1_0.tar.gz -C /
	# Kernel is default for RPi 2
	# To Change Kernel to RPi A/B if neccesary:
	if [ "$(cat /proc/cpuinfo | grep Hardware | grep BCM2708 | wc -l)" -gt "0" ]; then
		sed -i 's/kernel7_hat.img/kernel_hat.img/' /boot/config.txt
	fi  			
fi

if [ "$1" == "Adafruit28inch" ]; then
	curl -SLs https://raw.githubusercontent.com/adafruit/Raspberry-Pi-Installer-Scripts/main/converted_shell_scripts/adafruit-pitft.sh -o /opt/max2play/adafruit-pitft.sh
	chmod +x /opt/max2play/adafruit-pitft.sh
	# Set show commandline to NO and mirror HDMI to YES
	sudo /opt/max2play/adafruit-pitft.sh << EOF	
1
1
n
y
n
EOF
	echo "Set Display Resolution to 320x240"
	sed -i 's/^hdmi_cvt=640 480 60 1 0 0 0/hdmi_cvt=320 240 60 1 0 0 0/' /boot/config.txt
	echo "finished <b><a href='/plugins/max2play_settings/controller/Basic.php?action=reboot'>Please Reboot!</a></b>"
	exit 0
fi

if [ "$1" == "Adafruit35inch" ]; then
	curl -SLs https://raw.githubusercontent.com/adafruit/Raspberry-Pi-Installer-Scripts/main/converted_shell_scripts/adafruit-pitft.sh -o /opt/max2play/adafruit-pitft.sh
	chmod +x /opt/max2play/adafruit-pitft.sh
	sudo /opt/max2play/adafruit-pitft.sh << EOF	
4
1
n
y
n
EOF
	echo "Set Display Resolution to 480x320"
	sed -i 's/^hdmi_cvt=720 480 60 1 0 0 0/hdmi_cvt=480 320 60 1 0 0 0/' /boot/config.txt	
	echo "finished <b><a href='/plugins/max2play_settings/controller/Basic.php?action=reboot'>Please Reboot!</a></b>"
	exit 0
fi


# Framebuffer to see same picture on HDMI and TFT
echo "--- Installing fbcp ---"
cd /tmp
apt-get install -y git build-essential cmake
git clone --depth=1 https://github.com/tasanakorn/rpi-fbcp
mkdir -p rpi-fbcp/build
cd rpi-fbcp/build
cmake ..
make
install fbcp /usr/local/bin/fbcp
cd ../..
rm -r rpi-fbcp
curl -L --output /etc/init.d/fbcp https://github.com/watterott/RPi-Display/raw/master/docu/fbcp
chmod +x /etc/init.d/fbcp 


# Touchscreen Tools
apt-get install tslib libts-bin xinput --yes --force-yes
cd /tmp
wget http://tronnes.org/downloads/xinput-calibrator_0.7.5-1_armhf.deb
dpkg -i -B xinput-calibrator_0.7.5-1_armhf.deb
rm xinput-calibrator_0.7.5-1_armhf.deb

# FBTFT Device Tree enabled Kernel
sed -i 's/.*dtoverlay.*/dtoverlay=rpi-display,speed=32000000,rotate=270/' /boot/config.txt

CMDLINESET=$(grep -i "fbcon=map:10" /boot/cmdline.txt | wc -l) 
if [ "$CMDLINESET" -lt "1" ]; then
	echo "Show console on touchscreen"
	sed -i 's/rootwait/rootwait fbcon=map:10 fbcon=font:VGA8x8/' /boot/cmdline.txt
fi	

echo "Enable for X-Window-System"
if [ -e /usr/share/X11/xorg.conf.d/99-fbturbo.conf ]; then
	sed -i 's@/dev/fb0@/dev/fb1@' /usr/share/X11/xorg.conf.d/99-fbturbo.conf
else
	echo -e "Section \"Device\"\n  Identifier \"TFT\"\n  Driver \"fbdev\"\n  Option \"fbdev\" \"/dev/fb1\"\nEndSection" > /usr/share/X11/xorg.conf.d/99-fbturbo.conf
fi

if [ -e /etc/X11/xorg.conf.d ]; then
	echo "Directory /etc/X11/xorg.conf.d existing"	
else
	mkdir /etc/X11/xorg.conf.d
fi

# on Stretch use different config with Transformation Matrix
if [ "$VERSION" == "jessie" ]; then
	echo -e "Section \"InputClass\"\n    Identifier \"Touchscreen\"\n    MatchProduct \"ADS7846 Touchscreen\"\n    Option \"EmulateThirdButton\" \"1\"\n    Option \"EmulateThirdButtonTimeout\" \"1500\"\n    Option \"EmulateThirdButtonMoveThreshold\" \"30\"\n    Option \"InvertX\" \"0\"\n    Option \"InvertY\" \"1\"\n    Option \"SwapAxes\" \"1\"\nEndSection\n" > /etc/X11/xorg.conf.d/99-ads7846-cal.conf
else
	echo -e "Section \"InputClass\"\n    Identifier \"calibration\"\n    MatchProduct \"ADS7846 Touchscreen\"\n    Option \"EmulateThirdButton\" \"1\"\n    Option \"EmulateThirdButtonTimeout\" \"1500\"\n    Option \"EmulateThirdButtonMoveThreshold\" \"30\"\n    Option \"InvertX\" \"0\"\n    Option \"InvertY\" \"1\"\n    Option \"SwapAxes\" \"1\"\n    Option \"TransformationMatrix\" \"0 1 0 -1 0 1 0 0 1\"\nEndSection\n" > /etc/X11/xorg.conf.d/99-ads7846-cal.conf
fi
echo "finished <b><a href='/plugins/max2play_settings/controller/Basic.php?action=reboot'>Please Reboot!</a></b>"
