<?php
/**
	 RPi Display Setup
	
	 @Copyright 2015 Stefan Rick
	 @author Stefan Rick
	 Mail: stefan@rick-software.de
 	 Web: http://www.netzberater.de

 */ 
?>											
<style>
<!--
.description {
    list-style: circle outside none;
    padding-left: 20px;
}
-->
</style>

<h1 class="entry-header">
	<?php echo _t("RPi-Display Touchscreen Setup") ?>
</h1>
<div class="entry-content">
	<?php if(isset($rpid->view->message[0])){ ?>
		<div class="ui-widget">
			<div class="ui-state-highlight ui-corner-all" style="margin-bottom: 10px; padding: 0.4em .7em;">
				<p>
					<span class="ui-icon ui-icon-info" style="float: left; margin-right: .3em;"></span>
					<?php echo implode('<br />', $rpid->view->message); ?>					
				</p>
			</div>
		</div>
	<?php } ?>		
	
	<?php echo _t("Easy Installer to get your Display working. The touchscreen can be used with the Addon Jivelite and other desktop applications. With Jivelite and the touchdisplay you have a Squeezebox touch ready to go!") ?>
	<br /><br />
	<?php echo _t("<b>Notes on this installer:</b><br>Installation may need a restart if you have a kernelversion below 4.x. In this case you need to reboot after the first install attempt and click on install a second time after reboot is finished.") ?>	
	
	<br /><br />
	<?php echo _t("<b>Important:</b><br>The touchscreen might burn a shadow image on the display, if it is showing the same image over a long period of time! You can prevent this by using screensavers in the Apps (like Jivelite) and disabling the console, if not needed.") ?>	
	<br /><br />
	
	<form action="" method="get">
	<input type="hidden" id="action" name="action" value="" />
	
<?php if($rpid->view->installed) { ?>			
	
	<p class="ui-state-default ui-corner-all" style="padding:4px;margin-bottom:1em;">
			<span class="ui-icon ui-icon-video" style="float:left; margin:-2px 5px 0 0;"></span>
			<?php echo str_replace('$SERVICENAME', $rpid->viewname, _('$SERVICENAME is installed')) ?>: <?php if($rpid->view->displaytype) echo $rpid->supportedDisplays[$rpid->view->displaytype]; ?>				
	</p>
	
	<b><?php echo _t('Basic Settings') ?>:</b><br />		
	<div class="optiondetails"> 
		<table class="settings">
		  <tr>
			<td><?php echo _t('Activate Console Output on Touchscreen') ?></td>
			<td>
				<input type="checkbox" <?php if($rpid->view->consoleenabled == 1) echo "checked"; ?> value="1" name="consoleenabled" />	
			</td>
			<td><?php echo _t("Remember that showing the same screen over a long period of time may damage your screen! Console output is meant for debugging. Not working for 7-inch display!") ?></td> 
		  </tr>
		  <tr>
			<td><?php echo _t('Rotate display of Touchscreen') ?></td>
			<td>
				<input type="checkbox" <?php if($rpid->view->rotatedisplay > 0) echo "checked"; ?> value="1" name="rotatedisplay" />	
			</td>
			<td><?php echo _t("To change the orientation of your touchscreen.") ?></td> 
		  </tr>  
		   <tr>
			<td><?php echo _t('LCD as Default Display') ?></td>
			<td>
				<input type="checkbox" <?php if($rpid->view->display_default_lcd !== "0") echo "checked"; ?> value="1" name="display_default_lcd" />	
			</td>
			<td><?php echo _t("If disabled, the HDMI will be used as primary display.") ?></td> 
		  </tr>  
		  <tr>
			<td><?php echo _t('Remove Cursor (e.g. mouse pointer)') ?></td>
			<td>
				<input type="checkbox" <?php if($rpid->view->removecursor == 1) echo "checked"; ?> value="1" name="removecursor" />	
			</td>
			<td><?php echo _t("Some apps look better without a cursor on the screen.") ?></td> 
		  </tr>  
		  <tr>
			<td><?php echo _t('Kodi Mouse 1-Click') ?></td>
			<td>
				<input type="checkbox" <?php if($rpid->view->koditouchmouse == 1) echo "checked"; ?> value="1" name="koditouchmouse" />	
			</td>
			<td><?php echo _t("Improves Kodi usage on touchscreen by changing navigation to single click instead of double click. You need to start Kodi once before activating this feature.") ?></td> 
		  </tr>
		  <tr>
			<td><?php echo _t('Change Brightness of Display') ?></td>
			<td>
				<input type="text" value="<?php echo $rpid->view->brightness ?>" name="brightness" />	
			</td>
			<td><?php echo _t("Adopt brightness of display. Valid values are 0 to 255 (Default). As the display uses a lot of power to show white, you might lower the brightness (e.g. to 128) to increase stability.") ?></td> 
		  </tr>
		</table>
		<br />
		<input type="button" value="<?php echo _('save') ?>" name="save" onclick="document.getElementById('action').value='save';submit();" />
	</div>					
	<br /><br />
		
<?php }else { ?>	
	<p class="ui-state-default ui-corner-all" style="padding:4px;margin-bottom:1em;">
		<span class="ui-icon ui-icon-gear" style="float:left; margin:-2px 5px 0 0;"></span>
		<?php echo str_replace('$NAME', $rpid->viewname, _('$NAME start installation')) ?></p>	
	<?php echo _t("Choose your Display")?>: <select name="display">
	<?php foreach($rpid->supportedDisplays as $key => $value){ ?>
		<option value="<?php echo $key?>"><?php echo $value?></option>
	<?php }?>
	</select>
	&nbsp;&nbsp;
	<input type="button" value="<?php echo str_replace('$NAME', $rpid->viewname, _('$NAME start installation')) ?>" name="install" onclick="document.getElementById('action').value='install';submit();" />
	
<?php } ?>					
	
	<br /><br />
	<?php echo _t('Jivelite or Kodi not running on HDMI ("Error: unable to open display")? Try this to remove any settins related to installed displays:') ?><br />
	<input type="button" value="<?php echo _t('Remove any Display-Settings') ?>" name="removeDisplaySettings" onclick="document.getElementById('action').value='removeDisplaySettings';submit();" />
	</form>

	<br /><br />
	<a href="#javascript" onclick="document.getElementById('debug').style.display='';return false;">DEBUG Info</a>
	<textarea id="debug" rows="30" cols="70" style="display:none;"><?php foreach ($rpid->view->debug as $key => $debug) {
			echo "#### ". $key. " ####\n"; 
			 echo $debug." \n\n"; 
		 }?>
	</textarea>

</div>	